/*
	DevSaver Web Framework
	Copyright (c) 2013-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/


var STBModuleMedia = Object.create(STBModule.prototype);

STBModuleMedia.name = "ModuleMedia";

STBModuleMedia.initCarousel = function() {

        var postImageDir = false,
            owlSlide = $('.owl-carousel.owl-post-slider:not(.__done)');

        if ($("html").attr("dir") == "rtl") {
            postImageDir = true;
        }

		if (owlSlide.length > 0) {

			var obj		= owlSlide,
				$time	= STBUtils.attrDefaultValue(obj.attr("data-speed"), 2000),
				$dots	= STBUtils.attrDefaultValue(obj.attr("data-dots"), "1") == "1",
				$nav	= STBUtils.attrDefaultValue(obj.attr("data-nav"), "1") == "1",
				$auto	= STBUtils.attrDefaultValue(obj.attr("data-auto"), "1") == "1",
				$height = STBUtils.attrDefaultValue(obj.attr("data-height"), "1") == "1";

            var callOwl = function () {


                obj.owlCarousel({
                    rtl: postImageDir,
                    loop: true,
                    dots: $dots,
                    nav: $nav,
					autoplay: $auto,
					autoplayTimeout: $time,
					autoplayHoverPause: true,

                    navText: false,
                    video: true,
                    responsiveClass: true,
                    autoHeight: $height,
                    items: 1
                });

				//if carousel inside a isotope then force redraw
				var iso = obj.closest(".isotope-container");
				if (iso.length > 0)	{
					if (iso.data("isotope")) {
						iso.isotope('layout');
					}	
				}
            };

            owlSlide.each(function() {
				$(this).imagesLoaded(callOwl);
				$(this).addClass("__done");
			});
        }
}

STBModuleMedia.runOnContentUpdate = function() {
	STBModuleMedia.initCarousel();
}

STBModuleMedia.runOnReady = function () {
	STBModuleMedia.initCarousel();
}

site.registerModule(STBModuleMedia);